/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.scr.impl.helper.Coercions;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.helper.ReferenceMethod;
import org.apache.felix.scr.impl.helper.ReferenceMethods;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentActivator;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.EdgeInfo;
import org.apache.felix.scr.impl.manager.ExtendedServiceEvent;
import org.apache.felix.scr.impl.manager.MultiplePrototypeRefPair;
import org.apache.felix.scr.impl.manager.RefPair;
import org.apache.felix.scr.impl.manager.ReferenceManager;
import org.apache.felix.scr.impl.manager.ServiceTracker;
import org.apache.felix.scr.impl.manager.ServiceTrackerCustomizer;
import org.apache.felix.scr.impl.manager.SinglePrototypeRefPair;
import org.apache.felix.scr.impl.manager.SingleRefPair;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.apache.felix.scr.impl.metadata.ServiceMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentException;

public class DependencyManager<S, T>
implements ReferenceManager<S, T> {
    private final AbstractComponentManager<S> m_componentManager;
    private final ReferenceMetadata m_dependencyMetadata;
    private final int m_index;
    private volatile Customizer<S, T> m_customizer;
    private volatile ReferenceMethods m_bindMethods;
    private volatile ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> m_tracker;
    private volatile String m_target;
    private volatile int m_minCardinality;
    private static final String OBJECTCLASS_CLAUSE = "(objectClass=";
    private static final String PROTOTYPE_SCOPE_CLAUSE = "(service.scope=prototype)";

    DependencyManager(AbstractComponentManager<S> componentManager, ReferenceMetadata dependency, int index) {
        this.m_componentManager = componentManager;
        this.m_dependencyMetadata = dependency;
        this.m_index = index;
        this.m_customizer = this.newCustomizer();
        this.m_minCardinality = DependencyManager.defaultMinimumCardinality(dependency);
        if (this.m_componentManager.isLogEnabled(4)) {
            this.m_componentManager.log(4, "Dependency Manager created " + dependency.getDebugInfo(), null);
        }
    }

    private static int defaultMinimumCardinality(ReferenceMetadata dependency) {
        return dependency.isOptional() ? 0 : 1;
    }

    int getIndex() {
        return this.m_index;
    }

    void initBindingMethods(ReferenceMethods bindMethods) {
        this.m_bindMethods = bindMethods;
    }

    private String getServiceName() {
        return this.m_dependencyMetadata.getInterface();
    }

    boolean isOptional() {
        return this.m_dependencyMetadata.isOptional();
    }

    private boolean isEffectivelyOptional() {
        return this.m_minCardinality == 0;
    }

    private boolean cardinalitySatisfied(int serviceCount) {
        return this.m_minCardinality <= serviceCount;
    }

    private boolean cardinalityJustSatisfied(int serviceCount) {
        return this.m_minCardinality == serviceCount;
    }

    private boolean isMultiple() {
        return this.m_dependencyMetadata.isMultiple();
    }

    private boolean isStatic() {
        return this.m_dependencyMetadata.isStatic();
    }

    private boolean isReluctant() {
        return this.m_dependencyMetadata.isReluctant();
    }

    void deactivate() {
        this.m_customizer.close();
    }

    int size() {
        AtomicInteger trackingCount = new AtomicInteger();
        return this.m_tracker.getTracked(null, trackingCount).size();
    }

    private ServiceReference<T>[] getFrameworkServiceReferences(String targetFilter) {
        if (this.hasGetPermission()) {
            ComponentActivator bca = this.m_componentManager.getActivator();
            if (bca == null) {
                return null;
            }
            BundleContext bc = bca.getBundleContext();
            if (bc == null) {
                return null;
            }
            try {
                return bc.getServiceReferences(this.m_dependencyMetadata.getInterface(), targetFilter);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (InvalidSyntaxException ise) {
                this.m_componentManager.log(1, "Unexpected problem with filter ''{0}''", new Object[]{targetFilter}, ise);
                return null;
            }
        }
        this.m_componentManager.log(4, "No permission to access the services", null);
        return null;
    }

    private RefPair<S, T> getBestRefPair() {
        Collection<RefPair<S, T>> refs = this.m_customizer.getRefs(new AtomicInteger());
        if (refs.isEmpty()) {
            return null;
        }
        return refs.iterator().next();
    }

    T getService(ComponentContextImpl<S> key) {
        RefPair<S, T> sr = this.getBestRefPair();
        return this.getService(key, sr);
    }

    T[] getServices(ComponentContextImpl<S> key) {
        Collection<RefPair<S, T>> refs = this.m_customizer.getRefs(new AtomicInteger());
        ArrayList<T> services = new ArrayList<T>(refs.size());
        for (RefPair<S, T> ref : refs) {
            T service = this.getService(key, ref);
            if (service == null) continue;
            services.add(service);
        }
        return services.isEmpty() ? null : services.toArray(new Object[services.size()]);
    }

    @Override
    public List<ServiceReference<?>> getServiceReferences() {
        Collection<RefPair<S, T>> bound = this.m_customizer.getRefs(new AtomicInteger());
        ArrayList result = new ArrayList(bound.size());
        for (RefPair<S, T> ref : bound) {
            result.add(ref.getRef());
        }
        return result;
    }

    private RefPair<S, T> getRefPair(ServiceReference<T> serviceReference) {
        ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> tracker = this.m_tracker;
        if (tracker != null) {
            AtomicInteger trackingCount = new AtomicInteger();
            return (RefPair)tracker.getTracked(null, trackingCount).get(serviceReference);
        }
        return null;
    }

    T getService(ComponentContextImpl<S> key, ServiceReference<T> serviceReference) {
        RefPair<S, T> refPair = this.getRefPair(serviceReference);
        return this.getService(key, refPair);
    }

    private T getService(ComponentContextImpl<S> key, RefPair<S, T> refPair) {
        if (refPair == null) {
            return null;
        }
        T serviceObject = refPair.getServiceObject(key);
        if (serviceObject != null) {
            return serviceObject;
        }
        BundleContext bundleContext = this.m_componentManager.getBundleContext();
        if (bundleContext == null) {
            this.m_componentManager.log(1, "Bundle shut down while getting service {0} ({1}/{2,number,#})", new Object[]{this.getName(), this.m_dependencyMetadata.getInterface(), refPair.getRef().getProperty("service.id")}, null);
            return null;
        }
        try {
            refPair.getServiceObject(key, bundleContext, this.m_componentManager);
            serviceObject = refPair.getServiceObject(key);
        }
        catch (Exception e) {
            this.m_componentManager.log(1, "Failed getting service {0} ({1}/{2,number,#})", new Object[]{this.getName(), this.m_dependencyMetadata.getInterface(), refPair.getRef().getProperty("service.id")}, e);
            return null;
        }
        return serviceObject;
    }

    @Override
    public String getName() {
        return this.m_dependencyMetadata.getName();
    }

    @Override
    public boolean isSatisfied() {
        return this.m_customizer.isSatisfied();
    }

    public boolean hasGetPermission() {
        if (System.getSecurityManager() != null) {
            ServicePermission perm = new ServicePermission(this.getServiceName(), "get");
            return this.m_componentManager.getBundle().hasPermission((Object)perm);
        }
        return true;
    }

    boolean prebind(ComponentContextImpl<S> key) {
        return this.m_customizer.prebind(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean open(ComponentContextImpl<S> componentContext, EdgeInfo edgeInfo) {
        CountDownLatch openLatch;
        Collection<RefPair<S, T>> refs;
        if (!this.invokeInitMethod(componentContext)) {
            this.m_componentManager.log(4, "For dependency {0}, failed to initialize object", new Object[]{this.getName()}, null);
            return false;
        }
        int serviceCount = 0;
        AtomicInteger trackingCount = new AtomicInteger();
        ServiceTracker.Tracked tracked = this.m_tracker.tracked();
        synchronized (tracked) {
            refs = this.m_customizer.getRefs(trackingCount);
            edgeInfo.setOpen(trackingCount.get());
            openLatch = edgeInfo.getOpenLatch();
        }
        this.m_componentManager.log(4, "For dependency {0}, optional: {1}; to bind: {2}", new Object[]{this.getName(), this.isOptional(), refs}, null);
        for (RefPair refPair : refs) {
            if (refPair.isDeleted() || refPair.isFailed()) continue;
            if (!this.doInvokeBindMethod(componentContext, refPair, trackingCount.get())) {
                this.m_componentManager.log(4, "For dependency {0}, failed to invoke bind method on object {1}", new Object[]{this.getName(), refPair}, null);
            }
            ++serviceCount;
        }
        openLatch.countDown();
        return this.cardinalitySatisfied(serviceCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(ComponentContextImpl<S> componentContext, EdgeInfo edgeInfo) {
        CountDownLatch latch;
        Collection<RefPair<S, T>> refPairs;
        boolean doUnbind = componentContext != null && this.m_dependencyMetadata.getUnbind() != null;
        AtomicInteger trackingCount = new AtomicInteger();
        ServiceTracker.Tracked tracked = this.m_tracker.tracked();
        synchronized (tracked) {
            refPairs = this.m_customizer.getRefs(trackingCount);
            edgeInfo.setClose(trackingCount.get());
            latch = edgeInfo.getCloseLatch();
        }
        this.m_componentManager.log(4, "DependencyManager: {0} close component unbinding from {1} at tracking count {2} refpairs: {3}", new Object[]{this.getName(), componentContext, trackingCount.get(), refPairs}, null);
        this.m_componentManager.waitForTracked(trackingCount.get());
        for (RefPair refPair : refPairs) {
            if (!doUnbind || refPair.isFailed()) continue;
            this.invokeUnbindMethod(componentContext, refPair, trackingCount.get(), edgeInfo);
        }
        latch.countDown();
    }

    public void invokeBindMethodLate(ServiceReference<T> ref, int trackingCount) {
        RefPair<S, T> refPair;
        if (!this.isSatisfied()) {
            return;
        }
        if (!this.isMultiple()) {
            Collection<RefPair<S, T>> refs = this.m_customizer.getRefs(new AtomicInteger());
            if (refs.isEmpty()) {
                return;
            }
            RefPair<S, T> test = refs.iterator().next();
            if (ref != test.getRef()) {
                return;
            }
        }
        if ((refPair = this.m_tracker.getService(ref)) == null) {
            return;
        }
        this.m_componentManager.invokeBindMethod(this, refPair, trackingCount);
    }

    boolean invokeInitMethod(ComponentContextImpl<S> componentContext) {
        S componentInstance;
        if (this.m_bindMethods.getInit() != null && (componentInstance = componentContext.getImplementationObject(false)) != null) {
            return this.m_bindMethods.getInit().init(componentInstance, this.m_componentManager);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean invokeBindMethod(ComponentContextImpl<S> componentContext, RefPair<S, T> refPair, int trackingCount, EdgeInfo info) {
        if (componentContext.getImplementationObject(false) != null) {
            ServiceTracker.Tracked tracked = this.m_tracker.tracked();
            synchronized (tracked) {
                if (info.outOfRange(trackingCount)) {
                    return true;
                }
            }
            return this.doInvokeBindMethod(componentContext, refPair, trackingCount);
        }
        this.m_componentManager.log(4, "DependencyManager : component not yet created, assuming bind method call succeeded", null);
        return true;
    }

    private boolean doInvokeBindMethod(ComponentContextImpl<S> componentContext, RefPair<S, T> refPair, int trackingCount) {
        if (!this.getServiceObject(componentContext, this.m_bindMethods.getBind(), refPair)) {
            this.m_componentManager.log(2, "DependencyManager : invokeBindMethod : Service not available from service registry for ServiceReference {0} for reference {1}", new Object[]{refPair.getRef(), this.getName()}, null);
            return false;
        }
        MethodResult result = this.m_bindMethods.getBind().invoke(componentContext.getImplementationObject(false), componentContext, refPair, MethodResult.VOID, this.m_componentManager);
        if (result == null) {
            return false;
        }
        this.m_componentManager.setServiceProperties(result, trackingCount);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean invokeUpdatedMethod(ComponentContextImpl<S> componentContext, RefPair<S, T> refPair, int trackingCount, EdgeInfo info) {
        if (this.m_dependencyMetadata.getUpdated() == null && this.m_dependencyMetadata.getField() == null) {
            return false;
        }
        if (componentContext != null) {
            ServiceTracker.Tracked tracked = this.m_tracker.tracked();
            synchronized (tracked) {
                if (info.outOfRange(trackingCount)) {
                    return false;
                }
            }
            info.waitForOpen(this.m_componentManager, this.getName(), "invokeUpdatedMethod");
            if (!this.getServiceObject(componentContext, this.m_bindMethods.getUpdated(), refPair)) {
                this.m_componentManager.log(2, "DependencyManager : invokeUpdatedMethod : Service not available from service registry for ServiceReference {0} for reference {1}", new Object[]{refPair.getRef(), this.getName()}, null);
                return false;
            }
            MethodResult methodResult = this.m_bindMethods.getUpdated().invoke(componentContext.getImplementationObject(false), componentContext, refPair, MethodResult.VOID, this.m_componentManager);
            if (methodResult != null) {
                this.m_componentManager.setServiceProperties(methodResult, trackingCount);
            }
            return methodResult == MethodResult.REACTIVATE;
        }
        this.m_componentManager.log(4, "DependencyManager : Component not set, no need to call updated method", null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeUnbindMethod(ComponentContextImpl<S> componentContext, RefPair<S, T> refPair, int trackingCount, EdgeInfo info) {
        if (componentContext != null) {
            boolean outOfRange;
            ServiceTracker.Tracked tracked = this.m_tracker.tracked();
            synchronized (tracked) {
                if (info.beforeRange(trackingCount)) {
                    return;
                }
            }
            info.waitForOpen(this.m_componentManager, this.getName(), "invokeUnbindMethod");
            ServiceTracker.Tracked tracked2 = this.m_tracker.tracked();
            synchronized (tracked2) {
                outOfRange = info.afterRange(trackingCount);
            }
            if (outOfRange) {
                info.waitForClose(this.m_componentManager, this.getName(), "invokeUnbindMethod");
                return;
            }
            if (!this.getServiceObject(componentContext, this.m_bindMethods.getUnbind(), refPair)) {
                this.m_componentManager.log(2, "DependencyManager : invokeUnbindMethod : Service not available from service registry for ServiceReference {0} for reference {1}", new Object[]{refPair.getRef(), this.getName()}, null);
                return;
            }
            MethodResult methodResult = this.m_bindMethods.getUnbind().invoke(componentContext.getImplementationObject(false), componentContext, refPair, MethodResult.VOID, this.m_componentManager);
            if (methodResult != null) {
                this.m_componentManager.setServiceProperties(methodResult, trackingCount);
            }
            componentContext.getComponentServiceObjectsHelper().closeServiceObjects(refPair.getRef());
        } else {
            this.m_componentManager.log(4, "DependencyManager : Component not set, no need to call unbind method", null);
        }
    }

    boolean canUpdateDynamically(Map<String, Object> properties) {
        String newTarget = (String)properties.get(this.m_dependencyMetadata.getTargetPropertyName());
        String currentTarget = this.getTarget();
        int newMinimumCardinality = this.getMinimumCardinality(properties);
        if (this.m_minCardinality == newMinimumCardinality && (currentTarget == null && newTarget == null || currentTarget != null && currentTarget.equals(newTarget))) {
            return true;
        }
        if (this.m_dependencyMetadata.isStatic()) {
            return false;
        }
        if (newMinimumCardinality == 0) {
            return true;
        }
        ServiceReference<T>[] refs = this.getFrameworkServiceReferences(newTarget);
        if (refs != null) {
            return newMinimumCardinality <= refs.length;
        }
        return false;
    }

    void setTargetFilter(Map<String, Object> properties) {
        Integer minimumCardinality = this.getMinimumCardinality(properties);
        this.setTargetFilter((String)properties.get(this.m_dependencyMetadata.getTargetPropertyName()), minimumCardinality);
    }

    private int getMinimumCardinality(Map<String, Object> properties) {
        Integer minimumCardinality = null;
        try {
            minimumCardinality = Coercions.coerceToInteger(properties.get(this.m_dependencyMetadata.getMinCardinalityName()));
        }
        catch (ComponentException e) {
            this.m_componentManager.log(2, "Invalid minimum cardinality property for dependency {0}: {1}", new Object[]{this.getName(), e.getMessage()}, null);
        }
        if (minimumCardinality != null && (minimumCardinality < DependencyManager.defaultMinimumCardinality(this.m_dependencyMetadata) || !this.m_dependencyMetadata.isMultiple() && minimumCardinality > 1)) {
            minimumCardinality = null;
        }
        if (minimumCardinality == null) {
            minimumCardinality = DependencyManager.defaultMinimumCardinality(this.m_dependencyMetadata);
        }
        return minimumCardinality;
    }

    private void setTargetFilter(String target, int minimumCardinality) {
        String eventFilterString;
        if (target == null) {
            target = this.m_dependencyMetadata.getTarget();
        }
        if (this.m_target == null && target == null || this.m_target != null && this.m_target.equals(target)) {
            this.m_componentManager.log(4, "No change in target property for dependency {0}: currently registered: {1}", new Object[]{this.getName(), this.m_tracker != null}, null);
            if (this.m_tracker != null) {
                this.m_minCardinality = minimumCardinality;
                return;
            }
        }
        this.m_target = target;
        boolean multipleExpr = this.m_target != null || this.m_dependencyMetadata.getScope() == ReferenceMetadata.ReferenceScope.prototype_required;
        boolean allExpr = this.m_target != null && this.m_dependencyMetadata.getScope() == ReferenceMetadata.ReferenceScope.prototype_required;
        StringBuilder initialReferenceFilterSB = new StringBuilder();
        if (multipleExpr) {
            initialReferenceFilterSB.append("(&");
        }
        String classFilterString = OBJECTCLASS_CLAUSE + this.m_dependencyMetadata.getInterface() + ")";
        initialReferenceFilterSB.append(classFilterString);
        if (this.m_dependencyMetadata.getScope() == ReferenceMetadata.ReferenceScope.prototype_required) {
            initialReferenceFilterSB.append(PROTOTYPE_SCOPE_CLAUSE);
        }
        if (this.m_target != null) {
            initialReferenceFilterSB.append(this.m_target);
        }
        if (multipleExpr) {
            initialReferenceFilterSB.append(')');
        }
        String initialReferenceFilterString = initialReferenceFilterSB.toString();
        if (allExpr) {
            StringBuilder sb = new StringBuilder("(&").append(PROTOTYPE_SCOPE_CLAUSE).append(this.m_target).append(")");
            eventFilterString = sb.toString();
        } else {
            eventFilterString = this.m_target;
        }
        ServiceTracker<RefPair<S, T>, RefPair<T, RefPair<S, T>>, ExtendedServiceEvent> oldTracker = this.m_tracker;
        AtomicInteger trackingCount = new AtomicInteger();
        SortedMap<ServiceReference<T>, RefPair<S, T>> refMap = this.unregisterServiceListener(trackingCount);
        if (trackingCount.get() != -1) {
            this.m_componentManager.waitForTracked(trackingCount.get());
        }
        this.m_componentManager.log(4, "Setting target property for dependency {0} to {1}", new Object[]{this.getName(), target}, null);
        BundleContext bundleContext = this.m_componentManager.getBundleContext();
        Filter eventFilter = null;
        if (bundleContext != null) {
            if (eventFilterString != null) {
                try {
                    eventFilter = bundleContext.createFilter(eventFilterString);
                }
                catch (InvalidSyntaxException ise) {
                    this.m_componentManager.log(1, "Invalid syntax in target property for dependency {0} to {1}", new Object[]{this.getName(), target}, null);
                    eventFilterString = "(component.id=-1)";
                    try {
                        eventFilter = bundleContext.createFilter(eventFilterString);
                    }
                    catch (InvalidSyntaxException e) {
                        return;
                    }
                }
            }
        } else {
            this.m_componentManager.log(1, "Bundle is shut down for dependency {0} to {1}", new Object[]{this.getName(), target}, null);
            return;
        }
        this.m_customizer.setPreviousRefMap(refMap);
        boolean initialActive = oldTracker != null && oldTracker.isActive();
        this.m_componentManager.log(4, "New service tracker for {0}, initial active: {1}, previous references: {2}, classFilter: {3}, eventFilter {4}, initialReferenceFilter {5}", new Object[]{this.getName(), initialActive, refMap, classFilterString, eventFilter, initialReferenceFilterString}, null);
        ServiceTracker tracker = new ServiceTracker(bundleContext, this.m_customizer, initialActive, this.m_componentManager.getActivator(), eventFilter, classFilterString, initialReferenceFilterString);
        this.m_customizer.setTracker(tracker);
        this.m_minCardinality = minimumCardinality;
        tracker.open(this.m_componentManager.getTrackingCount());
        this.m_customizer.setTrackerOpened();
        if (oldTracker != null) {
            oldTracker.completeClose(refMap);
        }
        this.m_componentManager.log(4, "registering service listener for dependency {0}", new Object[]{this.getName()}, null);
    }

    private Customizer<S, T> newCustomizer() {
        Customizer customizer;
        if (!this.hasGetPermission()) {
            customizer = new NoPermissionsCustomizer();
            this.m_componentManager.log(3, "No permission to get services for {0}", new Object[]{this.getName()}, null);
        } else {
            customizer = this.m_componentManager.isFactory() ? new FactoryCustomizer() : (this.isMultiple() ? (this.isStatic() ? (this.isReluctant() ? new MultipleStaticReluctantCustomizer() : new MultipleStaticGreedyCustomizer()) : new MultipleDynamicCustomizer()) : (this.isStatic() ? new SingleStaticCustomizer() : new SingleDynamicCustomizer()));
        }
        return customizer;
    }

    SortedMap<ServiceReference<T>, RefPair<S, T>> unregisterServiceListener(AtomicInteger trackingCount) {
        SortedMap<ServiceReference<T>, RefPair<S, T>> refMap;
        ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> tracker = this.m_tracker;
        if (tracker != null) {
            refMap = tracker.close(trackingCount);
            this.m_tracker = null;
            this.m_componentManager.log(4, "unregistering service listener for dependency {0}", new Object[]{this.getName()}, null);
        } else {
            refMap = new TreeMap(Collections.reverseOrder());
            this.m_componentManager.log(4, " No existing service listener to unregister for dependency {0}", new Object[]{this.getName()}, null);
            trackingCount.set(-1);
        }
        return refMap;
    }

    @Override
    public String getTarget() {
        return this.m_target;
    }

    public String toString() {
        return "DependencyManager: Component [" + this.m_componentManager + "] reference [" + this.getName() + "]";
    }

    boolean getServiceObject(ComponentContextImpl<S> key, ReferenceMethod bindMethod, RefPair<S, T> refPair) {
        BundleContext bundleContext = this.m_componentManager.getBundleContext();
        if (bundleContext != null) {
            return bindMethod.getServiceObject(key, refPair, bundleContext, this.m_componentManager);
        }
        refPair.setFailed();
        return false;
    }

    RefPair<S, T> newRefPair(ServiceReference<T> serviceReference) {
        if (this.m_dependencyMetadata.getScope() == ReferenceMetadata.ReferenceScope.bundle) {
            return new SingleRefPair(serviceReference);
        }
        if (this.m_componentManager.getComponentMetadata().getServiceScope() == ServiceMetadata.Scope.singleton) {
            return new SinglePrototypeRefPair(this.m_componentManager.getBundleContext(), serviceReference);
        }
        return new MultiplePrototypeRefPair(this.m_componentManager.getBundleContext(), serviceReference);
    }

    private void deactivateComponentManager() {
        this.m_componentManager.deactivateInternal(2, false, false);
    }

    private class NoPermissionsCustomizer
    implements Customizer<S, T> {
        private NoPermissionsCustomizer() {
        }

        @Override
        public boolean prebind(ComponentContextImpl<S> key) {
            return false;
        }

        @Override
        public void close() {
        }

        @Override
        public Collection<RefPair<S, T>> getRefs(AtomicInteger trackingCount) {
            return Collections.emptyList();
        }

        @Override
        public boolean isSatisfied() {
            return DependencyManager.this.isOptional();
        }

        @Override
        public void setTracker(ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> tRefPairServiceTracker) {
        }

        @Override
        public void setTrackerOpened() {
        }

        @Override
        public void setPreviousRefMap(Map<ServiceReference<T>, RefPair<S, T>> previousRefMap) {
        }

        @Override
        public RefPair<S, T> addingService(ServiceReference<T> tServiceReference) {
            return null;
        }

        @Override
        public void addedService(ServiceReference<T> tServiceReference, RefPair<S, T> service, int trackingCount, int serviceCount, ExtendedServiceEvent event) {
        }

        @Override
        public void modifiedService(ServiceReference<T> tServiceReference, RefPair<S, T> service, int trackingCount, ExtendedServiceEvent event) {
        }

        @Override
        public void removedService(ServiceReference<T> tServiceReference, RefPair<S, T> service, int trackingCount, ExtendedServiceEvent event) {
        }
    }

    private class SingleStaticCustomizer
    extends AbstractCustomizer {
        private RefPair<S, T> refPair;
        private int trackingCount;

        private SingleStaticCustomizer() {
        }

        @Override
        public RefPair<S, T> addingService(ServiceReference<T> serviceReference) {
            RefPair refPair = DependencyManager.this.newRefPair(serviceReference);
            return refPair;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, int serviceCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleStatic added {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            this.trackingCount = trackingCount;
            this.tracked(trackingCount);
            if (this.isActive()) {
                boolean reactivate;
                ServiceTracker.Tracked tracked = this.getTracker().tracked();
                synchronized (tracked) {
                    reactivate = !DependencyManager.this.isReluctant() && (this.refPair == null || refPair.getRef().compareTo(this.refPair.getRef()) > 0);
                }
                if (reactivate) {
                    DependencyManager.this.deactivateComponentManager();
                    if (event != null) {
                        event.addComponentManager(DependencyManager.this.m_componentManager);
                    }
                } else {
                    DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleStatic active but new {2} is worse match than old {3}", new Object[]{DependencyManager.this.getName(), trackingCount, refPair, this.refPair}, null);
                }
            } else if (this.isTrackerOpened() && DependencyManager.this.cardinalityJustSatisfied(serviceCount)) {
                DependencyManager.this.m_componentManager.activateInternal();
            } else {
                DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleStatic active: {2} trackerOpened: {3} optional: {4}", new Object[]{DependencyManager.this.getName(), trackingCount, this.isActive(), this.isTrackerOpened(), DependencyManager.this.isOptional()}, null);
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleStatic added {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void modifiedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            boolean invokeUpdated;
            ServiceTracker.Tracked sync;
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleStatic modified {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            ServiceTracker.Tracked tracked = sync = this.getTracker().tracked();
            synchronized (tracked) {
                invokeUpdated = this.isActive() && refPair == this.refPair;
            }
            boolean reactivate = false;
            if (invokeUpdated) {
                reactivate = DependencyManager.this.m_componentManager.invokeUpdatedMethod(DependencyManager.this, refPair, trackingCount);
            }
            this.trackingCount = trackingCount;
            this.tracked(trackingCount);
            if (reactivate) {
                DependencyManager.this.deactivateComponentManager();
                ServiceTracker.Tracked tracked2 = sync;
                synchronized (tracked2) {
                    if (refPair == this.refPair) {
                        this.refPair = null;
                    }
                }
                if (event != null) {
                    event.addComponentManager(DependencyManager.this.m_componentManager);
                }
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleStatic modified {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            boolean reactivate;
            ServiceTracker.Tracked sync;
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleStatic removed {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            refPair.markDeleted();
            this.trackingCount = trackingCount;
            this.tracked(trackingCount);
            ServiceTracker.Tracked tracked = sync = this.getTracker().tracked();
            synchronized (tracked) {
                boolean bl = reactivate = this.isActive() && refPair == this.refPair || !DependencyManager.this.cardinalitySatisfied(this.getTracker().getServiceCount());
                if (!reactivate && refPair == this.refPair) {
                    this.refPair = null;
                }
            }
            if (reactivate) {
                DependencyManager.this.deactivateComponentManager();
                tracked = sync;
                synchronized (tracked) {
                    if (refPair == this.refPair) {
                        this.refPair = null;
                    }
                }
                if (event != null) {
                    event.addComponentManager(DependencyManager.this.m_componentManager);
                }
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleStatic removed {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean prebind(ComponentContextImpl<S> key) {
            boolean success = DependencyManager.this.cardinalitySatisfied(0);
            if (success || !this.getTracker().isEmpty()) {
                RefPair refPair = null;
                AtomicInteger trackingCount = new AtomicInteger();
                ServiceTracker.Tracked tracked = this.getTracker().tracked();
                synchronized (tracked) {
                    SortedMap tracked2 = this.getTracker().getTracked(true, trackingCount);
                    if (!tracked2.isEmpty()) {
                        refPair = tracked2.values().iterator().next();
                        this.refPair = refPair;
                    }
                }
                if (refPair != null) {
                    success |= DependencyManager.this.getServiceObject(key, DependencyManager.this.m_bindMethods.getBind(), refPair);
                    if (refPair.isFailed()) {
                        DependencyManager.this.m_componentManager.registerMissingDependency(DependencyManager.this, refPair.getRef(), trackingCount.get());
                    }
                }
            }
            return success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            ServiceTracker tracker = this.getTracker();
            if (tracker != null) {
                RefPair ref;
                ServiceTracker.Tracked tracked = tracker.tracked();
                synchronized (tracked) {
                    ref = this.refPair;
                    this.refPair = null;
                }
                if (ref != null) {
                    this.ungetService(ref);
                }
                tracker.deactivate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<RefPair<S, T>> getRefs(AtomicInteger trackingCount) {
            ServiceTracker.Tracked monitor;
            ServiceTracker.Tracked tracked = monitor = this.getTracker() == null ? null : this.getTracker().tracked();
            if (monitor != null) {
                ServiceTracker.Tracked tracked2 = monitor;
                synchronized (tracked2) {
                    trackingCount.set(this.trackingCount);
                    return this.refPair == null ? Collections.emptyList() : Collections.singleton(this.refPair);
                }
            }
            return Collections.emptyList();
        }
    }

    private class SingleDynamicCustomizer
    extends AbstractCustomizer {
        private RefPair<S, T> refPair;
        private int trackingCount;

        private SingleDynamicCustomizer() {
        }

        @Override
        public RefPair<S, T> addingService(ServiceReference<T> serviceReference) {
            RefPair refPair = this.getPreviousRefMap().get(serviceReference);
            if (refPair == null) {
                refPair = DependencyManager.this.newRefPair(serviceReference);
            }
            return refPair;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, int serviceCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleDynamic added {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            boolean tracked = false;
            if (this.getPreviousRefMap().remove(serviceReference) == null) {
                if (this.isActive()) {
                    boolean invokeBind;
                    ServiceTracker.Tracked tracked2 = this.getTracker().tracked();
                    synchronized (tracked2) {
                        invokeBind = this.refPair == null || !DependencyManager.this.isReluctant() && refPair.getRef().compareTo(this.refPair.getRef()) > 0;
                    }
                    if (invokeBind) {
                        DependencyManager.this.m_componentManager.invokeBindMethod(DependencyManager.this, refPair, trackingCount);
                        if (!refPair.isFailed()) {
                            if (this.refPair != null) {
                                DependencyManager.this.m_componentManager.invokeUnbindMethod(DependencyManager.this, this.refPair, trackingCount);
                                this.closeRefPair();
                            }
                        } else if (DependencyManager.this.cardinalitySatisfied(0)) {
                            DependencyManager.this.m_componentManager.registerMissingDependency(DependencyManager.this, serviceReference, trackingCount);
                        }
                        this.refPair = refPair;
                    }
                } else if (this.isTrackerOpened() && DependencyManager.this.cardinalityJustSatisfied(serviceCount)) {
                    this.tracked(trackingCount);
                    tracked = true;
                    DependencyManager.this.m_componentManager.activateInternal();
                }
            }
            this.trackingCount = trackingCount;
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleDynamic added {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            if (!tracked) {
                this.tracked(trackingCount);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void modifiedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            boolean invokeUpdated;
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleDynamic modified {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            ServiceTracker.Tracked tracked = this.getTracker().tracked();
            synchronized (tracked) {
                invokeUpdated = this.isActive() && refPair == this.refPair;
            }
            if (invokeUpdated) {
                DependencyManager.this.m_componentManager.invokeUpdatedMethod(DependencyManager.this, refPair, trackingCount);
            }
            this.trackingCount = trackingCount;
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleDynamic modified {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            this.tracked(trackingCount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleDynamic removed {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            refPair.markDeleted();
            boolean deactivate = false;
            boolean untracked = true;
            RefPair oldRefPair = null;
            RefPair nextRefPair = null;
            ServiceTracker.Tracked tracked = this.getTracker().tracked();
            synchronized (tracked) {
                if (refPair == this.refPair && this.isActive()) {
                    if (!this.getTracker().isEmpty()) {
                        AtomicInteger trackingCount2 = new AtomicInteger();
                        SortedMap tracked2 = this.getTracker().getTracked(true, trackingCount2);
                        nextRefPair = tracked2.values().iterator().next();
                    }
                    if (DependencyManager.this.isEffectivelyOptional() || nextRefPair != null) {
                        oldRefPair = this.refPair;
                        this.refPair = null;
                    } else {
                        deactivate = true;
                    }
                } else if (!DependencyManager.this.cardinalitySatisfied(this.getTracker().getServiceCount()) && this.refPair == null) {
                    deactivate = true;
                }
            }
            if (nextRefPair != null) {
                DependencyManager.this.m_componentManager.invokeBindMethod(DependencyManager.this, nextRefPair, trackingCount);
            }
            if (oldRefPair != null) {
                this.trackingCount = trackingCount;
                DependencyManager.this.m_componentManager.invokeUnbindMethod(DependencyManager.this, oldRefPair, trackingCount);
                tracked = this.getTracker().tracked();
                synchronized (tracked) {
                    this.refPair = nextRefPair;
                }
                this.tracked(trackingCount);
                untracked = false;
            } else if (deactivate) {
                this.trackingCount = trackingCount;
                this.tracked(trackingCount);
                untracked = false;
                DependencyManager.this.deactivateComponentManager();
            }
            if (oldRefPair != null) {
                this.ungetService(oldRefPair);
            }
            if (untracked) {
                this.trackingCount = trackingCount;
                this.tracked(trackingCount);
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleDynamic removed {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean prebind(ComponentContextImpl<S> key) {
            RefPair refPair = null;
            boolean success = DependencyManager.this.cardinalitySatisfied(0);
            AtomicInteger trackingCount = new AtomicInteger();
            ServiceTracker.Tracked tracked = this.getTracker().tracked();
            synchronized (tracked) {
                SortedMap tracked2;
                if (!(!success && this.getTracker().isEmpty() || (tracked2 = this.getTracker().getTracked(true, trackingCount)).isEmpty())) {
                    refPair = tracked2.values().iterator().next();
                    this.refPair = refPair;
                }
            }
            if (refPair != null) {
                success |= DependencyManager.this.getServiceObject(key, DependencyManager.this.m_bindMethods.getBind(), refPair);
                if (refPair.isFailed() && DependencyManager.this.cardinalitySatisfied(0)) {
                    DependencyManager.this.m_componentManager.registerMissingDependency(DependencyManager.this, refPair.getRef(), trackingCount.get());
                }
            }
            return success;
        }

        @Override
        public void close() {
            this.closeRefPair();
            this.deactivateTracker();
        }

        private void closeRefPair() {
            if (this.refPair != null) {
                this.ungetService(this.refPair);
            }
            this.refPair = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<RefPair<S, T>> getRefs(AtomicInteger trackingCount) {
            ServiceTracker.Tracked monitor;
            ServiceTracker.Tracked tracked = monitor = this.getTracker() == null ? null : this.getTracker().tracked();
            if (monitor != null) {
                ServiceTracker.Tracked tracked2 = monitor;
                synchronized (tracked2) {
                    trackingCount.set(this.trackingCount);
                    return this.refPair == null ? Collections.emptyList() : Collections.singleton(this.refPair);
                }
            }
            return Collections.emptyList();
        }
    }

    private class MultipleStaticReluctantCustomizer
    extends AbstractCustomizer {
        private final AtomicReference<Collection<RefPair<S, T>>> refs;
        private int trackingCount;

        private MultipleStaticReluctantCustomizer() {
            this.refs = new AtomicReference();
        }

        @Override
        public RefPair<S, T> addingService(ServiceReference<T> serviceReference) {
            RefPair refPair = DependencyManager.this.newRefPair(serviceReference);
            return refPair;
        }

        @Override
        public void addedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, int serviceCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticReluctant added {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            this.tracked(trackingCount);
            if (this.isTrackerOpened() && DependencyManager.this.cardinalityJustSatisfied(serviceCount) && !this.isActive()) {
                DependencyManager.this.m_componentManager.activateInternal();
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticReluctant added {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
        }

        @Override
        public void modifiedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticReluctant modified {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            boolean reactivate = false;
            Collection refs = this.refs.get();
            if (this.isActive() && refs.contains(refPair)) {
                reactivate = DependencyManager.this.m_componentManager.invokeUpdatedMethod(DependencyManager.this, refPair, trackingCount);
            }
            this.tracked(trackingCount);
            if (reactivate) {
                DependencyManager.this.deactivateComponentManager();
                if (event != null) {
                    event.addComponentManager(DependencyManager.this.m_componentManager);
                }
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticReluctant modified {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
        }

        @Override
        public void removedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticReluctant removed {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            refPair.markDeleted();
            this.tracked(trackingCount);
            Collection refs = this.refs.get();
            if (this.isActive() && refs != null) {
                if (refs.contains(refPair)) {
                    DependencyManager.this.m_componentManager.log(4, "Dependency Manager: Static dependency on {0}/{1} is broken", new Object[]{DependencyManager.this.getName(), DependencyManager.this.m_dependencyMetadata.getInterface()}, null);
                    DependencyManager.this.deactivateComponentManager();
                    if (event != null) {
                        event.addComponentManager(DependencyManager.this.m_componentManager);
                    }
                }
            } else if (!DependencyManager.this.cardinalitySatisfied(this.getTracker().getServiceCount())) {
                DependencyManager.this.m_componentManager.log(4, "Dependency Manager: Static dependency on {0}/{1} is broken", new Object[]{DependencyManager.this.getName(), DependencyManager.this.m_dependencyMetadata.getInterface()}, null);
                DependencyManager.this.deactivateComponentManager();
            }
            this.ungetService(refPair);
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticReluctant removed {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
        }

        @Override
        public boolean prebind(ComponentContextImpl<S> key) {
            int serviceCount = 0;
            Collection refs = this.refs.get();
            if (refs != null) {
                for (RefPair refPair : refs) {
                    if (!DependencyManager.this.getServiceObject(key, DependencyManager.this.m_bindMethods.getBind(), refPair)) continue;
                    ++serviceCount;
                }
                return DependencyManager.this.cardinalitySatisfied(serviceCount);
            }
            refs = new ArrayList();
            AtomicInteger trackingCount = new AtomicInteger();
            SortedMap tracked = this.getTracker().getTracked(true, trackingCount);
            for (RefPair refPair : tracked.values()) {
                if (DependencyManager.this.getServiceObject(key, DependencyManager.this.m_bindMethods.getBind(), refPair)) {
                    ++serviceCount;
                }
                refs.add(refPair);
            }
            if (this.refs.compareAndSet(null, refs)) {
                this.trackingCount = trackingCount.get();
            } else {
                Collection actualRefs = this.refs.get();
                refs.removeAll(actualRefs);
                for (RefPair ref : refs) {
                    this.ungetService(ref);
                }
            }
            return DependencyManager.this.cardinalitySatisfied(serviceCount);
        }

        @Override
        public void close() {
            Collection refs = this.refs.getAndSet(null);
            if (refs != null) {
                for (RefPair ref : refs) {
                    this.ungetService(ref);
                }
            }
            this.deactivateTracker();
        }

        @Override
        public Collection<RefPair<S, T>> getRefs(AtomicInteger trackingCount) {
            trackingCount.set(this.trackingCount);
            Collection refs = this.refs.get();
            return refs == null ? Collections.emptyList() : refs;
        }
    }

    private class MultipleStaticGreedyCustomizer
    extends AbstractCustomizer {
        private MultipleStaticGreedyCustomizer() {
        }

        @Override
        public RefPair<S, T> addingService(ServiceReference<T> serviceReference) {
            RefPair refPair = DependencyManager.this.newRefPair(serviceReference);
            return refPair;
        }

        @Override
        public void addedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, int serviceCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticGreedy added {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            this.tracked(trackingCount);
            if (this.isActive()) {
                DependencyManager.this.m_componentManager.log(4, "Dependency Manager: Static dependency on {0}/{1} is broken", new Object[]{DependencyManager.this.getName(), DependencyManager.this.m_dependencyMetadata.getInterface()}, null);
                DependencyManager.this.deactivateComponentManager();
                if (event != null) {
                    event.addComponentManager(DependencyManager.this.m_componentManager);
                }
            } else if (this.isTrackerOpened() && DependencyManager.this.cardinalityJustSatisfied(serviceCount)) {
                DependencyManager.this.m_componentManager.activateInternal();
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticGreedy added {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
        }

        @Override
        public void modifiedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticGreedy modified {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            boolean reactivate = false;
            if (this.isActive()) {
                reactivate = DependencyManager.this.m_componentManager.invokeUpdatedMethod(DependencyManager.this, refPair, trackingCount);
            }
            this.tracked(trackingCount);
            if (reactivate) {
                DependencyManager.this.deactivateComponentManager();
                if (event != null) {
                    event.addComponentManager(DependencyManager.this.m_componentManager);
                }
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticGreedy modified {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
        }

        @Override
        public void removedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticGreedy removed {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            refPair.markDeleted();
            this.tracked(trackingCount);
            if (this.isActive()) {
                DependencyManager.this.m_componentManager.log(4, "Dependency Manager: Static dependency on {0}/{1} is broken", new Object[]{DependencyManager.this.getName(), DependencyManager.this.m_dependencyMetadata.getInterface()}, null);
                DependencyManager.this.deactivateComponentManager();
                if (event != null) {
                    event.addComponentManager(DependencyManager.this.m_componentManager);
                }
            } else if (!DependencyManager.this.cardinalitySatisfied(this.getTracker().getServiceCount())) {
                DependencyManager.this.m_componentManager.log(4, "Dependency Manager: Static dependency on {0}/{1} is broken", new Object[]{DependencyManager.this.getName(), DependencyManager.this.m_dependencyMetadata.getInterface()}, null);
                DependencyManager.this.deactivateComponentManager();
            }
            this.ungetService(refPair);
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticGreedy removed {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
        }

        @Override
        public boolean prebind(ComponentContextImpl<S> key) {
            int serviceCount = 0;
            AtomicInteger trackingCount = new AtomicInteger();
            ServiceTracker tracker = this.getTracker();
            SortedMap tracked = tracker.getTracked(DependencyManager.this.cardinalitySatisfied(tracker.getServiceCount()), trackingCount);
            for (RefPair refPair : tracked.values()) {
                if (!DependencyManager.this.getServiceObject(key, DependencyManager.this.m_bindMethods.getBind(), refPair)) continue;
                ++serviceCount;
            }
            return DependencyManager.this.cardinalitySatisfied(serviceCount);
        }

        @Override
        public void close() {
            AtomicInteger trackingCount = new AtomicInteger();
            for (RefPair ref : this.getRefs(trackingCount)) {
                this.ungetService(ref);
            }
            this.deactivateTracker();
        }

        @Override
        public Collection<RefPair<S, T>> getRefs(AtomicInteger trackingCount) {
            ServiceTracker tracker = this.getTracker();
            if (tracker == null) {
                return Collections.emptyList();
            }
            return tracker.getTracked(null, trackingCount).values();
        }
    }

    private class MultipleDynamicCustomizer
    extends AbstractCustomizer {
        private RefPair<S, T> lastRefPair;
        private int lastRefPairTrackingCount;

        private MultipleDynamicCustomizer() {
        }

        @Override
        public RefPair<S, T> addingService(ServiceReference<T> serviceReference) {
            RefPair refPair = this.getPreviousRefMap().get(serviceReference);
            if (refPair == null) {
                refPair = DependencyManager.this.newRefPair(serviceReference);
            }
            return refPair;
        }

        @Override
        public void addedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, int serviceCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleDynamic added {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            boolean tracked = false;
            if (this.getPreviousRefMap().remove(serviceReference) == null) {
                if (this.isActive()) {
                    DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleDynamic already active, binding {2}", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
                    DependencyManager.this.m_componentManager.invokeBindMethod(DependencyManager.this, refPair, trackingCount);
                    if (refPair.isFailed()) {
                        DependencyManager.this.m_componentManager.registerMissingDependency(DependencyManager.this, serviceReference, trackingCount);
                    }
                } else if (this.isTrackerOpened() && DependencyManager.this.cardinalityJustSatisfied(serviceCount)) {
                    DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleDynamic, activating", new Object[]{DependencyManager.this.getName(), trackingCount}, null);
                    this.tracked(trackingCount);
                    tracked = true;
                    DependencyManager.this.m_componentManager.activateInternal();
                } else {
                    DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleDynamic, inactive, doing nothing: tracker opened: {2}, optional: {3}", new Object[]{DependencyManager.this.getName(), trackingCount, this.isTrackerOpened(), DependencyManager.this.isOptional()}, null);
                }
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleDynamic added {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            if (!tracked) {
                this.tracked(trackingCount);
            }
        }

        @Override
        public void modifiedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleDynamic modified {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            if (this.isActive()) {
                DependencyManager.this.m_componentManager.invokeUpdatedMethod(DependencyManager.this, refPair, trackingCount);
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleDynamic modified {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            this.tracked(trackingCount);
        }

        @Override
        public void removedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleDynamic removed {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            refPair.markDeleted();
            boolean unbind = DependencyManager.this.cardinalitySatisfied(this.getTracker().getServiceCount());
            if (unbind) {
                if (this.isActive()) {
                    DependencyManager.this.m_componentManager.invokeUnbindMethod(DependencyManager.this, refPair, trackingCount);
                }
                DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleDynamic removed (unbind) {2}", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
                this.tracked(trackingCount);
            } else {
                this.lastRefPair = refPair;
                this.lastRefPairTrackingCount = trackingCount;
                this.tracked(trackingCount);
                DependencyManager.this.deactivateComponentManager();
                this.lastRefPair = null;
                DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleDynamic removed (deactivate) {2}", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            }
            this.ungetService(refPair);
        }

        @Override
        public boolean prebind(ComponentContextImpl<S> key) {
            int serviceCount = 0;
            AtomicInteger trackingCount = new AtomicInteger();
            SortedMap tracked = this.getTracker().getTracked(true, trackingCount);
            ArrayList failed = new ArrayList();
            for (RefPair refPair : tracked.values()) {
                if (DependencyManager.this.getServiceObject(key, DependencyManager.this.m_bindMethods.getBind(), refPair)) {
                    ++serviceCount;
                    continue;
                }
                failed.add(refPair);
            }
            if (DependencyManager.this.cardinalitySatisfied(serviceCount)) {
                for (RefPair refPair : failed) {
                    DependencyManager.this.m_componentManager.registerMissingDependency(DependencyManager.this, refPair.getRef(), trackingCount.get());
                }
                return true;
            }
            return false;
        }

        @Override
        public void close() {
            AtomicInteger trackingCount = new AtomicInteger();
            for (RefPair ref : this.getRefs(trackingCount)) {
                this.ungetService(ref);
            }
            this.deactivateTracker();
        }

        @Override
        public Collection<RefPair<S, T>> getRefs(AtomicInteger trackingCount) {
            if (this.lastRefPair == null) {
                ServiceTracker tracker = this.getTracker();
                if (tracker == null) {
                    trackingCount.set(this.lastRefPairTrackingCount);
                    return Collections.emptyList();
                }
                return this.getTracker().getTracked(null, trackingCount).values();
            }
            trackingCount.set(this.lastRefPairTrackingCount);
            return Collections.singletonList(this.lastRefPair);
        }
    }

    private class FactoryCustomizer
    extends AbstractCustomizer {
        private FactoryCustomizer() {
        }

        @Override
        public RefPair<S, T> addingService(ServiceReference<T> serviceReference) {
            RefPair refPair = DependencyManager.this.newRefPair(serviceReference);
            return refPair;
        }

        @Override
        public void addedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, int serviceCount, ExtendedServiceEvent event) {
            if (DependencyManager.this.cardinalityJustSatisfied(serviceCount)) {
                DependencyManager.this.m_componentManager.activateInternal();
            }
        }

        @Override
        public void modifiedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
        }

        @Override
        public void removedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            refPair.markDeleted();
            if (!DependencyManager.this.cardinalitySatisfied(this.getTracker().getServiceCount())) {
                DependencyManager.this.deactivateComponentManager();
            }
        }

        @Override
        public boolean prebind(ComponentContextImpl<S> key) {
            AtomicInteger trackingCount = new AtomicInteger();
            int serviceCount = this.getTracker().getTracked(true, trackingCount).size();
            return DependencyManager.this.cardinalitySatisfied(serviceCount);
        }

        @Override
        public void close() {
            this.deactivateTracker();
        }

        @Override
        public Collection<RefPair<S, T>> getRefs(AtomicInteger trackingCount) {
            return Collections.emptyList();
        }
    }

    private abstract class AbstractCustomizer
    implements Customizer<S, T> {
        private final Map<ServiceReference<T>, RefPair<S, T>> EMPTY_REF_MAP = Collections.emptyMap();
        private volatile boolean trackerOpened;
        private volatile Map<ServiceReference<T>, RefPair<S, T>> previousRefMap = this.EMPTY_REF_MAP;

        private AbstractCustomizer() {
        }

        @Override
        public void setTracker(ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> tracker) {
            DependencyManager.this.m_tracker = tracker;
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracker reset (closed)", new Object[]{DependencyManager.this.getName()}, null);
            this.trackerOpened = false;
        }

        @Override
        public boolean isSatisfied() {
            ServiceTracker tracker = this.getTracker();
            if (tracker == null) {
                return false;
            }
            return DependencyManager.this.cardinalitySatisfied(tracker.getServiceCount());
        }

        protected ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> getTracker() {
            return DependencyManager.this.m_tracker;
        }

        protected boolean isActive() {
            return this.getTracker().isActive();
        }

        protected boolean isTrackerOpened() {
            return this.trackerOpened;
        }

        @Override
        public void setTrackerOpened() {
            this.trackerOpened = true;
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracker opened", new Object[]{DependencyManager.this.getName()}, null);
        }

        protected void deactivateTracker() {
            ServiceTracker tracker = this.getTracker();
            if (tracker != null) {
                tracker.deactivate();
            }
        }

        protected Map<ServiceReference<T>, RefPair<S, T>> getPreviousRefMap() {
            return this.previousRefMap;
        }

        @Override
        public void setPreviousRefMap(Map<ServiceReference<T>, RefPair<S, T>> previousRefMap) {
            this.previousRefMap = previousRefMap != null ? previousRefMap : this.EMPTY_REF_MAP;
        }

        protected void ungetService(RefPair<S, T> ref) {
            BundleContext bundleContext;
            Object service = ref.unsetServiceObject(null);
            if (service != null && (bundleContext = DependencyManager.this.m_componentManager.getBundleContext()) != null) {
                bundleContext.ungetService(ref.getRef());
            }
        }

        protected void tracked(int trackingCount) {
            DependencyManager.this.m_componentManager.tracked(trackingCount);
        }
    }

    private static interface Customizer<S, T>
    extends ServiceTrackerCustomizer<T, RefPair<S, T>, ExtendedServiceEvent> {
        public boolean prebind(ComponentContextImpl<S> var1);

        public void close();

        public Collection<RefPair<S, T>> getRefs(AtomicInteger var1);

        public boolean isSatisfied();

        public void setTracker(ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> var1);

        public void setTrackerOpened();

        public void setPreviousRefMap(Map<ServiceReference<T>, RefPair<S, T>> var1);
    }
}

